<?php
/*
Template Name: Blog Masonry Gallery Full Width
*/
?>
<?php get_header(); ?>
<?php

$hudson_edge_options = hudson_edge_return_global_options();
$hudson_edge_id = hudson_edge_get_page_id();
$hudson_edge_page_object = get_post( $hudson_edge_id );
$hudson_edge_content = $hudson_edge_page_object->post_content;
$hudson_edge_sidebar = hudson_edge_get_sidebar_layout();

if(get_post_meta($hudson_edge_id, "edgt_page_background_color", true) != ""){
	$hudson_edge_background_color = 'background-color: '.esc_attr(get_post_meta($hudson_edge_id, "edgt_page_background_color", true));
}else{
	$hudson_edge_background_color = "";
}

$hudson_edge_content_style = "";
if(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true) != ""){
	if(get_post_meta($hudson_edge_id, "edgt_content-top-padding-mobile", true) == 'yes'){
		$hudson_edge_content_style = "padding-top:".esc_attr(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true))."px !important";
	}else{
		$hudson_edge_content_style = "padding-top:".esc_attr(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true))."px";
	}
}

if(isset($hudson_edge_options['blog_masonry_gallery_number_of_chars'])&& $hudson_edge_options['blog_masonry_gallery_number_of_chars'] != "") {
	hudson_edge_set_blog_word_count(esc_attr($hudson_edge_options['blog_masonry_gallery_number_of_chars']));
}
$hudson_edge_category_filter = "no";
if(isset($hudson_edge_options['blog_masonry_gallery_filter'])){
	$hudson_edge_category_filter = $hudson_edge_options['blog_masonry_gallery_filter'];
}
$hudson_edge_container_inner_class = "";
if($hudson_edge_category_filter == "yes"){
	$hudson_edge_container_inner_class = " full_page_container_inner";
}
?>

	<?php get_template_part( 'title' ); ?>
	<?php get_template_part('slider'); ?>


	<div class="full_width" <?php hudson_edge_inline_style($hudson_edge_background_color); ?>>
		<div class="full_width_inner clearfix <?php echo esc_attr($hudson_edge_container_inner_class); ?>" <?php hudson_edge_inline_style($hudson_edge_content_style); ?>>
			<?php
				echo apply_filters( 'the_content', wp_kses_post($hudson_edge_content));
				get_template_part('templates/blog/blog', 'structure');
			?>
		</div>
	</div>
<?php get_footer(); ?>